
OPTIONS DATE;
***** SET PATH NAME AS APPROPRIATE FOR YOUR COMPUTER;
 
FILENAME USPS 'C:\stats\RMC06\FY2006.RMCforPRC.DAT';
LIBNAME IN 'C:\stats\RMC06\';
LIBNAME OUT 'C:\stats\RMC06\';

*************************** RMC_06.SAS ************************************************;
***  This part of the program converts the flat file {FY2006.RMCforPRC.DAT} which   ***;
***  contains the 2006 Rural Carrier National Mail Count data, into a SAS data set  ***;
*************************** RMC_06.SAS ************************************************;

/*  Variables describing the route and the route evaluation

RTTYPE	Route type: H, J, K (Evaluated), or A, M (Other)
MILES	Number of miles on the route
BOXESR	Number of regular mailboxes on the route 
BOXESC	Number of centralized mailboxes on the route
NDCBU	Neighborhood Delivery and Collection Box Units
PARLOCK	Parcel post lockers 

Counts of each item during mail count. Used to calculate average weekly pieces

LETTERS	Number of letters delivered 
FLATS	Number of flats delivered  
PARCELS	Number of parcels delivered     
BOXHOLD	Number of boxholder pieces delivered    
REGCERT	Number of registered, certified, etc. delivered
CODCUST	Number of C.O.D. and customs due   
CHGADDR	Number of change of address forms  
MARKUP	Number of markups (undeliverable mail)  
F3579	Number of forms 3579 and 3821 filled out  
DPS	    Number of dps pieces delivered     
SECSEG	Number of sector segment pieces delivered   
MONORDR	Number of money orders        
LETCOLL	Number of letter size pieces collected 
PARCACC	Number of parcel posts accepted  
REGACC	Number of registrd, cert., collected on route
POSTDUE	Number of postage dues   
LOADING	Loading vehicle       
ALLOW	Other suitable allowance count  = del conf scans 
DSMOUNT	Number of authorized dismounts      
DSMFEET	Dismount distance walked (feet) 
PURCHST	Purchase stamp count    
RETRCT	Number of return receipts 
POUCHST	Lock pouch stops     

Variables showing evaluated time allowances

DLLETRT	Time delivering letters 
DLFLATT	Time delivering flats   
DLPAROT	Time delivering parcels (office)   
DLPARRT	Time delivering parcels (route)  
WITHDT	Time withdrawing mail  
STRAPT	Time strap out (bands on lets/flats) to keep seq
LOADNGT	Time loading vehicle
RETRCTT	Time handling return receipts 
DISMNTT	Time for dismounts  
BOXHLDT	Time delivering boxholder mail   
CODCSOT	Time for C.O.D. and customs due, office   
DLREGOT	Time deliver registrd, certifd, office time  
MARKUPT	Time for Markups (undeliverable mail) 
ADDREST	Time for change of address forms   
MNORDOT	Time for Money orders, office time  
COLLFT	Time collecting letter size pieces  
PPACCOT	Time accepting parcel posts, office time   
STAMPST	Purchasing stamps for the route 
F3579T	Time filling out forms 3579 and 3821
ALLOWT	Other suitable allowances = del con scan time 
POSTDUT	Time for postage due 
PERSNLT	Time office work not in personal time  
CODCSRT	Time for C.O.D. and customs due, route time
DLREGRT	Time for Deliver registrd, certif, route time
MNORDRT	Time for Money orders, route time 
PPACCRT	Time for parcel posts accepted, route time  
COLREGT	Collecting registered, certified, etc. 
MILEST	Miles driven on the route  
BOXESRT	Number of regular boxes
BOXESCT	Number of centralized boxes
NDCBUT	Neighborhood Delivery and Collection Box Units
PARLCKT	Parcel post lockers 
POUCHT	Locked pouch delivery 
SECSEGT	Delivery of Sector Segment Pieces 
DPST	Time for DPS letter delilvery  
GOVVEHT	Time for loading/unloading Government Vehicles
REUNLDT	Time for reloading/Unloading 

TOTHRS	Total hours on the route 
TOTMIN	Minutes on the route   
ACTLHRS	Average weekly actual hours 
YEAR	Fiscal year the evaluation was taken */
*************************************************;
*****READ IN UNIVERSE DATA;                                       
DATA R1;
INFILE USPS LRECL=685 ; 
INPUT                                            
RTTYPE $ 1-5                                                          
 MILES  6-10                                                           
 BOXESR 11-20                                                          
 BOXESC 21-30                                                          
 NDCBU  31-40                                                          
 PARLOCK 41-50                                                         
 LETTERS 51-60                                                         
 FLATS   61-70                                                         
 PARCELS 71-80                                                         
 BOXHOLD 81-90                                                         
 REGCERT 91-100                                                        
 CODCUST 101-110                                                       
 CHGADDR 111-120                                                       
 MARKUP  121-130                                                       
 F3579   131-140                                                       
 DPS     141-150                                                       
 SECSEG  151-160                                                       
 MONORDR 161-170                                                       
 LETCOLL 171-180                                                       
 PARCACC 181-190                                                       
 REGACC  191-200                                                       
 POSTDUE 201-210                                                       
 LOADING 211-220                                                       
 ALLOW   221-230                                                       
 DSMOUNT 231-240                                                       
 DSMFEET 241-250                                                       
 PURCHST 251-260                                                       
 RETRCT  261-270                                                       
 POUCHST 271-280                                                       
 DLLETRT 281-290                                                       
 DLFLATT 291-300                                                       
 DLPAROT 301-310                                                       
 DLPARRT 311-320                                                       
 WITHDT  321-330                                                       
 STRAPT  331-340                                                       
 LOADNGT 341-350                                                       
 RETRCTT 351-360                                                       
 DISMNTT 361-370                                                       
 BOXHLDT 371-380                                                       
 CODCSOT 381-390                                                       
 DLREGOT 391-400                                                       
 MARKUPT 401-410                                                       
 ADDREST 411-420                                                       
 MNORDOT 421-430                                                       
 COLLFT  431-440                                                       
 PPACCOT 441-450                                                       
 STAMPST 451-460                                                       
 F3579T  461-470                                                       
 ALLOWT  471-480                                                       
 POSTDUT 481-490                                                       
 PERSNLT 491-500                                                       
 CODCSRT 501-510                                                       
 DLREGRT 511-520                                                       
 MNORDRT 521-530                                                       
 PPACCRT 531-540                                                       
 COLREGT 541-550                                                       
 MILEST  551-560                                                       
 BOXESRT 561-570                                                       
 BOXESCT 571-580                                                       
 NDCBUT  581-590                                                       
 PARLCKT 591-600                                                       
 POUCHT  601-610                                                       
 SECSEGT 611-620                                                       
 DPST    621-630                                                       
 GOVVEHT 631-640                                                       
 REUNLDT 641-650                                                       
 TOTHRS  651-660                                                       
 TOTMIN  661-670                                                       
 ACTLHRS 671-680                                                       
 YEAR    681-685;
DATA R2;
  SET R1;

  IF YEAR = 2002 THEN CNTLEN = 2;                                        
ELSE IF YEAR = 2003 THEN CNTLEN = 4;                                   
ELSE IF YEAR = 2004 THEN CNTLEN = 3;                                   
ELSE IF YEAR = 2005 THEN CNTLEN = 4;
ELSE IF YEAR = 2006 THEN CNTLEN = 2;                                   
OUTPUT;
****************************************************************
***** GLOBAL EDITING OF DATA(FY 2006 USPS SAS Program) **********
****************************************************************;
DATA R2;
  SET R2;

IF MILES > .05;
IF LETTERS > 0;
RUN;
 
DATA R2;
  SET R2;
TBOXES = BOXESR + BOXESC;
DENSITY = 'NL';
IF (TBOXES/MILES) >= 12 THEN DENSITY = 'L'; *CREATES THE VARIABLE 'DENSITY'; 
RUN;
DATA R2;
  SET R2;
IF RTTYPE = 'H' OR RTTYPE = 'J' OR RTTYPE = 'K' THEN TYPE = 'EVAL';    
ELSE IF RTTYPE = 'A' OR RTTYPE = 'M' THEN TYPE = 'OTHR';               
ELSE DELETE; 
RUN;
***************************************************************
* VARIABLE SPECIFIC EDITING OF DATA (FY 2006 USPS SAS Program)*
***************************************************************; 
DATA R3;
  SET R2;

IF LOADNGT > 90 THEN LOADNGT = 90;                                     

IF DENSITY = 'L' THEN STAMPST=STAMPST; 
ELSE STAMPST=30;
 
IF PPACCRT = 0 THEN PPACCRT = PPACCOT;
***********************************************************
******* WEEKLY VALUES (FY 2006 USPS SAS Program) **********
***********************************************************;
*DEVELOPS WEEKLY DATA- average weekly volumes;
LETTERS=LETTERS/CNTLEN; FLATS=FLATS/CNTLEN; PARCELS=PARCELS/CNTLEN;
BOXHOLD=BOXHOLD/CNTLEN; REGCERT=REGCERT/CNTLEN; CODCUST=CODCUST/CNTLEN;
CHGADDR=CHGADDR/CNTLEN; MARKUP=MARKUP/CNTLEN; F3579=F3579/CNTLEN;
DPS=DPS/CNTLEN; SECSEG=SECSEG/CNTLEN; MONORDR=MONORDR/CNTLEN; 
LETCOLL=LETCOLL/CNTLEN;
PARCACC=PARCACC/CNTLEN; REGACC=REGACC/CNTLEN; POSTDUE=POSTDUE/CNTLEN;
LOADING=LOADING/CNTLEN; DSMOUNT=DSMOUNT/CNTLEN; 
DSMFEET=DSMFEET/CNTLEN; RETRCT=RETRCT/CNTLEN;

***********************************************************;
EVMNO=DLLETRT+DLFLATT+DLPAROT+WITHDT+STRAPT+LOADNGT+RETRCTT+
      BOXHLDT+CODCSOT+DLREGOT+MARKUPT+ADDREST+MNORDOT+PPACCOT+
      STAMPST+F3579T+ALLOWT+POSTDUT+PERSNLT+SECSEGT+DPST+GOVVEHT+REUNLDT;

EVMNR=DLPARRT+DISMNTT+COLLFT+CODCSRT+DLREGRT+MNORDRT+PPACCRT+COLREGT+
      MILEST+BOXESRT+BOXESCT+NDCBUT+PARLCKT+POUCHT;

TEVMN=EVMNO+EVMNR; *CALCULATES TOTAL EVALUATED TIME;  

EVHRSO=EVMNO/60;
EVHRSR=EVMNR/60;
TEVHRS=TEVMN/60;

TPCS=LETTERS+FLATS+PARCELS+BOXHOLD+DPS+SECSEG+POSTDUE;
***********************************************************
******** DAYLY VALUES (FY 2006 USPS SAS Program) **********
***********************************************************;
DATA R4;
  SET R3;
*DEVELOPS DAILY DATA;
LETTERS=LETTERS/6; FLATS=FLATS/6; PARCELS=PARCELS/6;
BOXHOLD=BOXHOLD/6; REGCERT=REGCERT/6; CODCUST=CODCUST/6;
CHGADDR=CHGADDR/6; MARKUP=MARKUP/6; F3579=F3579/6;
DPS=DPS/6; SECSEG=SECSEG/6; MONORDR=MONORDR/6; 
LETCOLL=LETCOLL/6;
PARCACC=PARCACC/6; REGACC=REGACC/6; POSTDUE=POSTDUE/6;
LOADING=LOADING/6; DSMOUNT=DSMOUNT/6; 
DSMFEET=DSMFEET/6; RETRCT=RETRCT/6;
TPCS=TPCS/6;

DLLETRT=DLLETRT/6; DLFLATT=DLFLATT/6; DLPAROT=DLPAROT/6; 
WITHDT=WITHDT/6; STRAPT=STRAPT/6; LOADNGT=LOADNGT/6;
RETRCTT=RETRCTT/6; BOXHLDT=BOXHLDT/6; CODCSOT=CODCSOT/6;
DLREGOT=DLREGOT/6; MARKUPT=MARKUPT/6; ADDREST=ADDREST/6;
MNORDOT=MNORDOT/6; PPACCOT=PPACCOT/6; 
STAMPST=STAMPST/6; F3579T=F3579T/6; ALLOWT=ALLOWT/6;  
POSTDUT=POSTDUT/6; PERSNLT=PERSNLT/6; SECSEGT=SECSEGT/6;
DPST=DPST/6; GOVVEHT=GOVVEHT/6; REUNLDT=REUNLDT/6;
DLPARRT=DLPARRT/6; DISMNTT=DISMNTT/6; COLLFT=COLLFT/6;
PPACCRT=PPACCRT/6; COLREGT=COLREGT/6; 
CODCSRT=CODCSRT/6; DLREGRT=DLREGRT/6; MNORDRT=MNORDRT/6; 
MILEST=MILEST/6; BOXESRT=BOXESRT/6; BOXESCT=BOXESCT/6;
NDCBUT=NDCBUT/6; PARLCKT=PARLCKT/6; POUCHT=POUCHT/6;

TOTHRS=TOTHRS/6; TOTMIN=TOTMIN/6; ACTLHRS=ACTLHRS/6;
EVMNO=EVMNO/6; EVMNR=EVMNR/6; TEVMN=TEVMN/6;
EVHRSO=EVHRSO/6; EVHRSR=EVHRSR/6; TEVHRS=TEVHRS/6;

***SPLIT TIMES BETWEEN FIXED AND VARIABLE;
 
F3579TF = MIN(F3579T,12.);                                             
F3579TV = F3579T - F3579TF;

LOADTF = LOADNGT * .5;                                                 
LOADTV = LOADNGT * .5; 
 
STAMPTV = 0;
STAMPTF = 0;
IF DENSITY='L' THEN STAMPTV=STAMPST; 
ELSE STAMPTF=STAMPST;
 
FIXEDT= MILEST+BOXESRT+BOXESCT+NDCBUT+PARLCKT+POUCHT+         
        WITHDT+ADDREST+F3579TF+LOADTF+PERSNLT+STAMPTF+         
        ALLOWT+DISMNTT+GOVVEHT+REUNLDT;                            
                                                                       
VARIABLET= DLLETRT+DLFLATT+DLPAROT+DLPARRT+BOXHLDT+CODCSOT+CODCSRT+   
           DLREGOT+DLREGRT+MARKUPT+F3579TV+STRAPT+LOADTV+         
           MNORDOT+MNORDRT+COLLFT+PPACCOT+PPACCRT+COLREGT+        
           POSTDUT+STAMPTV+RETRCTT+DPST+SECSEGT;                  
                                                                       
TOTALT = FIXEDT + VARIABLET; 
VARIABILITY= VARIABLET / TOTALT;
* time spent on delivery/total time(delivery and nd);
************************************************************
*CALCULATION OF DAILY EQUIPMENT MAINTENANCE ALLOWANCE (EMA)*
************************************************************
*NOTE:ON JANUARY 7, 2006 (PAY PERIOD 02-06), THE RURAL CARRIER
*     DAILY EMA WAS SET AT 48.5 CENTS PER MILE OR A MINIMUM 
*     OF $19.40 PER DAY, WHICHEVER IS GREATER.
************************************************************;
EMA=0;
IF GOVVEHT=0 THEN DO;
EMA=MILES*0.485;
IF EMA<19.40 THEN EMA=19.40;
END;
* DEVELOPMENT OF DAILY RURAL DELIVERY COST PER ROUTE *;
LC_H=32.617285;    *RURAL CARRIER LABOR COST PER EVALUATED HOUR*;
                   
PGBFCTR=1.24296775;  *RURAL CARRIER PIGGYBACK FACTOR FOR SUPERVISION,
                      SPACE AND SPACE RELATED COSTS FROM ACR2007-1*;
                      
LC_R   =TEVHRS*LC_H;      *LABOR COST PER RURAL ROUTE*;
OHLC_R =LC_R*(PGBFCTR-1); *RURAL CARRIER OVERHEAD COST PER ROUTE*;
DC_R   =LC_R+OHLC_R+EMA;  *DELIVERY COST PER ROUTE= labor cost+ overhead+ maintenance;
VDC_R  =DC_R*VARIABILITY; *VARIABLE DELIVERY COST PER ROUTE*;
FDC_R  =DC_R-VDC_R;       *FIXED DELIVERY COST PER ROUTE*;

RETAIN SEQ 1;
IF SEQ < 73145 THEN DO; *73,144=NUMBER OF ROUTES IN RMC FY 2006*;
OUTPUT;
SEQ = SEQ+1;
END;
RUN;
DATA R5(KEEP=MILES LETTERS FLATS PARCELS BOXHOLD REGCERT CODCUST
BOXESRT BOXESR BOXESCT BOXESC
MONORDR LETCOLL PARCACC REGACC RETRCT
RETRCTT MNORDOT PPACCOT STAMPST ALLOWT
DISMNTT COLLFT MNORDRT PPACCRT COLREGT
LC_H PGBFCTR 
TOTMIN	ACTLHRS 
                  DPS SECSEG MONORDR POSTDUE RETRCT TBOXES EVHRSO EVHRSR TEVHRS
                  TOTALT TPCS VARIABILITY LC_R OHLC_R DC_R VDC_R FDC_R);
  SET R4;
  * added BOXESRT BOXESR BOXESCT BOXESC to be used in the rural analysis on density;
* added MONORDR LETCOLL PARCACC REGACC RETRCT
RETRCTT MNORDOT PPACCOT STAMPST ALLOWT
DISMNTT COLLFT MNORDRT PPACCRT COLREGT
LC_H PGBFCTR
to be used in the retail tranzaction analysis
*added TOTMIN	ACTLHRS for cleaning the dataset;
************************************************************************************;
*  THIS PART OF THE PROGRAM DOES THE FOLLOWING:                             					********;
*  IMPORTS DISTRIBUTION KEY VALUES FROM RURALMAILVOL KEYS.XLS   					
*  MULTIPLIES KEYS FOR EACH SHAPE BY RMC SHAPE VOLUME TO OBTAIN SHAPE VOLUME BY     
*  SUBCLASS THEN SUMS BY SUBCLASS FOR EACH SHAPE TO GET TOTAL VOLUME BY SHAPE AS CHECK 			  **;
***************************************************************************************;
***************************************************************************************;
**  IMPORT DISTRIBUTION KEYS FROM RURALMAILVOL KEYS.XLS                 ***************;
**  WORKSHEET "Import Vol Keys To SAS"                                  ***************;
************************************************************************************** ;
PROC IMPORT OUT= MSKEYS 
            DATAFILE= "C:\stats\RMC06\RMC06_SUPPORT.xls" 
            DBMS=EXCEL REPLACE;
     SHEET="'Import Vol Keys To SAS$'"; 
     GETNAMES=YES;
     DBSASLABEL=NONE;
RUN; 
*************MERGE SINGLE VALUE KEYS WITH RMC_06 DATASET  **************;
DATA R6 (Drop = F106-F117);
IF _N_ = 1 THEN SET MSKEYS;
SET R5;
attrib _all_ label = ''; * DELETES LABELS THAT SAS ADDS WHEN VALUES ARE IMPORTED FROM EXCEL*;
run;

DATA R7;
SET R6;
*************SUMS KEYS BY SUBCLASS TO CHECK IF THEY EQUAL 1 **************;

TDK1=FCSPL1 + FCPS1 + FCSPC1 + FCPSC1 + PRI1 + EXP1 + PER1 + STD_ECR1 + 
	STD_REG1 + PP1 + ML1 + BPM1 + USPS1 + FREE1 + INTL1;

TDK2=FCSPL2 + FCPS2 + FCSPC2 + FCPSC2 + PRI2 + EXP2 + PER2 + STD_ECR2 + 
	STD_REG2 + PP2 + ML2 + BPM2 + USPS2 + FREE2 + INTL2;

TDK3=FCSPL3 + FCPS3 + FCSPC3 + FCPSC3 + PRI3 + EXP3 + PER3 + STD_ECR3 + 
	STD_REG3 + PP3 + ML3 + BPM3 + USPS3 + FREE3 + INTL3;

TDK4=FCSPL4 + FCPS4 + FCSPC4 + FCPSC4 + PRI4 + EXP4 + PER4 + STD_ECR4 + 
	STD_REG4 + PP4 + ML4 + BPM4 + USPS4 + FREE4 + INTL4;


TDK5=FCSPL5 + FCPS5 + FCSPC5 + FCPSC5 + PRI5 + EXP5 + PER5 + STD_ECR5 + 
	STD_REG5 + PP5 + ML5 + BPM5 + USPS5 + FREE5 + INTL5;


TDK6=FCSPL6 + FCPS6 + FCSPC6 + FCPSC6 + PRI6 + EXP6 + PER6 + STD_ECR6 + 
	STD_REG6 + PP6 + ML6 + BPM6 + USPS6 + FREE6 + INTL6;


TDK7=FCSPL7 + FCPS7 + FCSPC7 + FCPSC7 + PRI7 + EXP7 + PER7 + STD_ECR7 + 
	STD_REG7 + PP7 + ML7 + BPM7 + USPS7 + FREE7 + INTL7;

RUN;

*************************************************************************;
**  IMPORT SPECIAL SERVICE DISTRIBUTION KEYS FROM RURALMAILVOL KEYS.XLS  
**  WORKSHEET "Import Spec Svc Keys Into SAS"                             
**************************************************************************;
PROC IMPORT OUT= SSKEYS 
            DATAFILE= "C:\stats\RMC06\RMC06_SUPPORT.xls" 
            DBMS=EXCEL REPLACE;
     SHEET="'Import Spec Svc Keys Into SAS$'"; 
     GETNAMES=YES;
     MIXED=NO;
     SCANTEXT=YES;
     USEDATE=YES;
     SCANTIME=YES;
RUN;

DATA R8;
SET SSKEYS;
IF . THEN DELETE; RUN;
******** MERGE SINGLE VALUE SPECIAL SERVICE KEYS WITH RMC3_06 DATASET  ***********;
**    FROM RURALMAILVOL KEYS.XLS, SHEET "Import Spec Svc Keys Into SAS"***********;
***********************************************************************************;
DATA R8 (DROP = F106-F117);
IF _N_ = 1 THEN SET SSKEYS;
SET R7;
attrib _all_ label = '';

TDK8 = Reg + Cert + Ins; *These should sum to 1.0 since they are a distinct 
                          volume category in the RCM*;
TDK9 = Cod; *This is its own volume category in the RCM*;
*********************************************************************;
* DISTRIBUTION OF DPS LETTER VOLUMES (V1)TO CLASSES using key values by subclass_shape= volume (subclass_shape)*;
DATA R9;
SET R8;
FCSPLV1	  =	FCSPL1*DPS;
FCPSV1	  =	FCPS1*DPS;
FCSPCV1	  =	FCSPC1*DPS;
FCPSCV1	  =	FCPSC1*DPS;
PRIV1	  =	PRI1*DPS;
EXPV1	  =	EXP1*DPS;
PERV1	  =	PER1*DPS;
STD_ECRV1 =	STD_ECR1*DPS;
STD_REGV1 =	STD_REG1*DPS;
PPV1	  =	PP1*DPS;
MLV1	  =	ML1*DPS;
BPMV1	  =	BPM1*DPS;
USPSV1	  =	USPS1*DPS;
FREEV1	  =	FREE1*DPS;
INTLV1	  =	INTL1*DPS;

*SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF DPS LETTERS=V1

*BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  *;

V1=FCSPLV1 + FCPSV1 + FCSPCV1 + FCPSCV1 + PRIV1 +
EXPV1 + PERV1 + STD_ECRV1 + STD_REGV1 + PPV1 +
MLV1 + BPMV1 + USPSV1 + FREEV1 + INTLV1;

* DISTRIBUTION OF OTHER LETTERS (V2) TO CLASSES= VOLUME (SUBCLASS_V2) *;
FCSPLV2	  =	FCSPL2*LETTERS;
FCPSV2	  =	FCPS2*LETTERS;
FCSPCV2	  =	FCSPC2*LETTERS;
FCPSCV2	  =	FCPSC2*LETTERS;
PRIV2	  =	PRI2*LETTERS;
EXPV2	  =	EXP2*LETTERS;
PERV2	  =	PER2*LETTERS;
STD_ECRV2 =	STD_ECR2*LETTERS;
STD_REGV2 =	STD_REG2*LETTERS;
PPV2	  =	PP2*LETTERS;
MLV2	  =	ML2*LETTERS;
BPMV2	  =	BPM2*LETTERS;
USPSV2	  =	USPS2*LETTERS;
FREEV2	  =	FREE2*LETTERS;
INTLV2	  =	INTL2*LETTERS;

* SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF OTHER LETTERS= V2 

*BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  *;
V2=FCSPLV2 + FCPSV2 + FCSPCV2 + FCPSCV2 + PRIV2 +
EXPV2 + PERV2 + STD_ECRV2 + STD_REGV2 + PPV2 +
MLV2 + BPMV2 + USPSV2 + FREEV2 + INTLV2;

* DISTRIBUTION OF SECTOR SEGMENT LETTERS (V3) TO CLASSES *;
FCSPLV3	  =	FCSPL3*SECSEG;
FCPSV3	  =	FCPS3*SECSEG;
FCSPCV3	  =	FCSPC3*SECSEG;
FCPSCV3	  =	FCPSC3*SECSEG;
PRIV3	  =	PRI3*SECSEG;
EXPV3	  =	EXP3*SECSEG;
PERV3	  =	PER3*SECSEG;
STD_ECRV3 =	STD_ECR3*SECSEG;
STD_REGV3 =	STD_REG3*SECSEG;
PPV3	  =	PP3*SECSEG;
MLV3	  =	ML3*SECSEG;
BPMV3	  =	BPM3*SECSEG;
USPSV3	  =	USPS3*SECSEG;
FREEV3	  =	FREE3*SECSEG;
INTLV3	  =	INTL3*SECSEG;

*SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF SECTOR SEGMENT LETTERS BY 
*SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES *;
V3=FCSPLV3 + FCPSV3 + FCSPCV3 + FCPSCV3 + PRIV3 +
EXPV3 + PERV3 + STD_ECRV3 + STD_REGV3 + PPV3 +
MLV3 + BPMV3 + USPSV3 + FREEV3 + INTLV3;


* DISTRIBUTION OF FLATS(V4)TO CLASSES *;
FCSPLV4	  =	FCSPL4*FLATS;
FCPSV4	  =	FCPS4*FLATS;
FCSPCV4	  =	FCSPC4*FLATS;
FCPSCV4	  =	FCPSC4*FLATS;
PRIV4	  =	PRI4*FLATS;
EXPV4	  =	EXP4*FLATS;
PERV4	  =	PER4*FLATS;
STD_ECRV4 =	STD_ECR4*FLATS;
STD_REGV4 =	STD_REG4*FLATS;
PPV4	  =	PP4*FLATS;
MLV4	  =	ML4*FLATS;
BPMV4	  =	BPM4*FLATS;
USPSV4	  =	USPS4*FLATS;
FREEV4	  =	FREE4*FLATS;
INTLV4	  =	INTL4*FLATS;

********* SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF FLATS BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  ********************;

V4=FCSPLV4 + FCPSV4 + FCSPCV4 + FCPSCV4 + PRIV4 +
EXPV4 + PERV4 + STD_ECRV4 + STD_REGV4 + PPV4 +
MLV4 + BPMV4 + USPSV4 + FREEV4 + INTLV4;

* DISTRIBUTION OF PARCELS (V5) TO CLASSES *;
FCSPLV5	  =	FCSPL5*PARCELS;
FCPSV5	  =	FCPS5*PARCELS;
FCSPCV5	  =	FCSPC5*PARCELS;
FCPSCV5	  =	FCPSC5*PARCELS;
PRIV5	  =	PRI5*PARCELS;
EXPV5	  =	EXP5*PARCELS;
PERV5	  =	PER5*PARCELS;
STD_ECRV5 =	STD_ECR5*PARCELS;
STD_REGV5  = STD_REG5*PARCELS;
PPV5	  =	PP5*PARCELS;
MLV5	  =	ML5*PARCELS;
BPMV5	  =	BPM5*PARCELS;
USPSV5	  =	USPS5*PARCELS;
FREEV5	  =	FREE5*PARCELS;
INTLV5	  =	INTL5*PARCELS;


********* SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF PARCELS BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  ********************;

V5=FCSPLV5 + FCPSV5 + FCSPCV5 + FCPSCV5 + PRIV5 +
EXPV5 + PERV5 + STD_ECRV5 + STD_REGV5 + PPV5 +
MLV5 + BPMV5 + USPSV5 + FREEV5 + INTLV5;

* DISTRIBUTION OF PARCELS (V6) TO CLASSES *;

FCSPLV6	  =	FCSPL6*BOXHOLD;
FCPSV6	  =	FCPS6*BOXHOLD;
FCSPCV6	  =	FCSPC6*BOXHOLD;
FCPSCV6	  =	FCPSC6*BOXHOLD;
PRIV6	  =	PRI6*BOXHOLD;
EXPV6	  =	EXP6*BOXHOLD;
PERV6	  =	PER6*BOXHOLD;
STD_ECRV6  = STD_ECR6*BOXHOLD;
STD_REGV6  = STD_REG6*BOXHOLD;
PPV6	  =	PP6*BOXHOLD;
MLV6	  =	ML6*BOXHOLD;
BPMV6	  =	BPM6*BOXHOLD;
USPSV6	  =	USPS6*BOXHOLD;
FREEV6	  =	FREE6*BOXHOLD;
INTLV6	  =	INTL6*BOXHOLD;

********* SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF BOXHOLDER VOLUMES BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  ********************;

V6=FCSPLV6 + FCPSV6 + FCSPCV6 + FCPSCV6 + PRIV6 +
EXPV6 + PERV6 + STD_ECRV6 + STD_REGV6 + PPV6 +
MLV6 + BPMV6 + USPSV6 + FREEV6 + INTLV6;

* DISTRIBUTION OF POSTAGE DUE (V7) TO CLASSES *;

FCSPLV7	  =	FCSPL7*POSTDUE;
FCPSV7	  =	FCPS7*POSTDUE;
FCSPCV7	  =	FCSPC7*POSTDUE;
FCPSCV7	  =	FCPSC7*POSTDUE;
PRIV7	  =	PRI7*POSTDUE;
EXPV7	  =	EXP7*POSTDUE;
PERV7	  =	PER7*POSTDUE;
STD_ECRV7  = STD_ECR7*POSTDUE;
STD_REGV7  = STD_REG7*POSTDUE;
PPV7	  =	PP7*POSTDUE;
MLV7	  =	ML7*POSTDUE;
BPMV7	  =	BPM7*POSTDUE;
USPSV7	  =	USPS7*POSTDUE;
FREEV7	  =	FREE7*POSTDUE;
INTLV7	  =	INTL7*POSTDUE;

********* SUMMING ACROSS SUBCLASSES TO OBTAIN  VOLUME OF SECTOR POSTAGE DUE BY SUBCLASS BY ROUTE BY MULTI-WEEK SAMPLES  ********************;

V7=FCSPLV7 + FCPSV7 + FCSPCV7 + FCPSCV7 + PRIV7 +
EXPV7 + PERV7 + STD_ECRV7 + STD_REGV7 + PPV7 +
MLV7 + BPMV7 + USPSV7 + FREEV7 + INTLV7;

* DISTRIBUTION OF REGISTERED, INSURANCE, CERTIFIED, ETC. (V8) NOT INCLUDED IN MAIL VOLUMES  *;

REGV  =	REG*REGCERT;
CERTV =	CERT*REGCERT;
INSV  =	INS*REGCERT;

V8 = REGV+CERTV+INSV;   *Shape is Registered, Certified, Insured, Etc.";

* DISTRIBUTION OF OTHER SPECIAL SERVICES (V9) NOT INCLUDED IN MAIL VOLUMES  *;
	
CODV	= COD*CODCUST;

V9	=	CODV;  *Shape is Customer COD*;

* MAIL VOLUME DELIVERED BY SUBCLASS= VOLUME(SUBCLASS)BY DAY *;

FCSPLV = FCSPLV1+FCSPLV2+FCSPLV3+FCSPLV4+FCSPLV5+FCSPLV6+FCSPLV7;
FCPSV = FCPSV1+FCPSV2+FCPSV3+FCPSV4+FCPSV5+FCPSV6+FCPSV7;
FCSPCV = FCSPCV1+FCSPCV2+FCSPCV3+FCSPCV4+FCSPCV5+FCSPCV6+FCSPCV7;
FCPSCV = FCPSCV1+FCPSCV2+FCPSCV3+FCPSCV4+FCPSCV5+FCPSCV6+FCPSCV7;
PRIV = PRIV1+PRIV2+PRIV3+PRIV4+PRIV5+PRIV6+PRIV7;
EXPV = EXPV1+EXPV2+EXPV3+EXPV4+EXPV5+EXPV6+EXPV7;
PERV = PERV1+PERV2+PERV3+PERV4+PERV5+PERV6+PERV7;
STD_ECRV  = STD_ECRV1 + STD_ECRV2 + STD_ECRV3 + STD_ECRV4 
			+ STD_ECRV5 + STD_ECRV6 + STD_ECRV7;
STD_REGV = STD_REGV1 + STD_REGV2 + STD_REGV3 + STD_REGV4 + 
			STD_REGV5 + STD_REGV6 + STD_REGV7;
PPV = PPV1+PPV2+PPV3+PPV4+PPV5+PPV6+PPV7;
MLV = MLV1+MLV2+MLV3+MLV4+MLV5+MLV6+MLV7;
BPMV = BPMV1+BPMV2+BPMV3+BPMV4+BPMV5+BPMV6+BPMV7;
USPSV = USPSV1+USPSV2+USPSV3+USPSV4+USPSV5+USPSV6+USPSV7;
FREEV = FREEV1+FREEV2+FREEV3+FREEV4+FREEV5+FREEV6+FREEV7;
INTLV = INTLV1+INTLV2+INTLV3+INTLV4+INTLV5+INTLV6+INTLV7;

* TOTAL MAIL VOLUME CHECK: BY SUBCLASS COMPARED TO BY SHAPE*;
TOTVOL_SUB = FCSPLV+FCPSV+FCSPCV+FCPSCV+PRIV+EXPV+PERV+STD_ECRV+STD_REGV+PPV+
			MLV+BPMV+USPSV+FREEV+INTLV ;
TOTVOL_SHAPE = V1+V2+V3+V4+V5+V6+V7;

RUN;
****************************************************************************************************;
***   VARIABLE NAMES IN THE "VOLUME" DATASET AND IN THE MEANS OUTPUT ARE SUMMED ACROSS ALL ROUTES  **;
***   VARIABLE NAMES ARE RETAINED IN VOLUME DATASET, NOT CHANGED                                   **;
***   "VOLUME" IS A TEMPORARY FILE AND IS LOCATED IN THE WORK. DIRECTORY WHEN PROGRAM IS RUN       **;
*****************************************************************************************************;

**********************************************************************;
***   IMPORT UNIT REVENUE AND UNIT NON-DELIVERY COSTS PER SUBCLASS  **;
**********************************************************************;

PROC IMPORT OUT= ARNDC 
            DATAFILE= "C:\stats\RMC06\RMC06_SUPPORT.xls" 
            DBMS=EXCEL REPLACE;
     SHEET="'REVCOST$'"; 
     GETNAMES=YES;
     MIXED=NO;
     SCANTEXT=YES;
     USEDATE=YES;
     SCANTIME=YES;
RUN;

*************MERGE SINGLE VALUE REVCOST VALUES WITH RMC3_06 DATASET  ********;

DATA R10;
IF _N_ = 1 THEN SET ARNDC;
SET R9;
attrib _all_ label = '';
run;
****************************************************************;
***  CREATE TOTAL REVENUE AND NON-DELIVERY COST PER ROUTE-DAY **;
****************************************************************;

**********REVENUE PER SUBCLASS  **************************;
DATA R11;
SET R10;
FCSPL_R = FCSPL_AR * FCSPLV;
FCPS_R = FCPS_AR * FCPSV;
FCSPC_R = FCSPC_AR * FCSPCV;
FCPSC_R = FCPSC_AR * FCPSCV;
PRI_R = PRI_AR * PRIV;
EXP_R = EXP_AR * EXPV;
PER_R = PER_AR * PERV;
STD_ECR_R = STD_ECR_AR * STD_ECRV;
STD_REG_R = STD_REG_AR * STD_REGV;
PP_R = PP_AR * PPV;
ML_R = ML_AR * MLV;
BPM_R = BPM_AR * BPMV;
USPS_R = USPS_AR * USPSV;
FREE_R = FREE_AR * FREEV;
INTL_R = INTL_AR * INTLV;
REG_R = REG_AR * REGV;
CERT_R = CERT_AR * CERTV;
INS_R = INS_AR * INSV;
COD_R = COD_AR * CODV;

*****************  NON DELIVERY COST PER SUBCLASS   **********;

FCSPL_NDC = FCSPL_ND * FCSPLV;
FCPS_NDC = FCPS_ND * FCPSV;
FCSPC_NDC = FCSPC_ND * FCSPCV;
FCPSC_NDC = FCPSC_ND * FCPSCV;
PRI_NDC = PRI_ND * PRIV;
EXP_NDC = EXP_ND * EXPV;
PER_NDC = PER_ND * PERV;
STD_ECR_NDC = STD_ECR_ND * STD_ECRV;
STD_REG_NDC = STD_REG_ND * STD_REGV;
PP_NDC = PP_ND * PPV;
ML_NDC = ML_ND * MLV;
BPM_NDC = BPM_ND * BPMV;
USPS_NDC = USPS_ND * USPSV;
FREE_NDC = FREE_ND * FREEV;
INTL_NDC = INTL_ND * INTLV;
REG_NDC = REG_ND * REGV;
CERT_NDC = CERT_ND * CERTV;
INS_NDC = INS_ND * INSV;
COD_NDC = COD_ND * CODV;

************************************************************************;
**  TOTAL RURAL REVENUE AND NON-DELIVERY COST PER ROUTE-DAY           **;
************************************************************************;

******* TOTAL RURAL NON-DELIVERY COST PER ROUTE-DAY   **************;

NDC_R = FCSPL_NDC + FCPS_NDC + FCSPC_NDC + FCPSC_NDC + PRI_NDC + EXP_NDC + 
  PER_NDC + STD_ECR_NDC + STD_REG_NDC + PP_NDC + ML_NDC + BPM_NDC + 
  USPS_NDC + FREE_NDC + INTL_NDC + REG_NDC + CERT_NDC + INS_NDC + COD_NDC;

 TC_R   =DC_R+NDC_R;       *TOTAL COST PER ROUTE-DAY*;

******* TOTAL RURAL REVENUE PER ROUTE-DAY   **************;

TR_R =FCSPL_R + FCPS_R + FCSPC_R + FCPSC_R + PRI_R + EXP_R+PER_R +
  STD_ECR_R + STD_REG_R + PP_R + ML_R + BPM_R + USPS_R + FREE_R + 
  INTL_R + REG_R + CERT_R + INS_R + COD_R;

PF_R  =TR_R-TC_R; *PROFIT PER ROUTE-DAY*;
 RUN;
 DATA OUT.RMC_06_long (KEEP=MILES BOXESRT BOXESR BOXESCT BOXESC
MONORDR LETCOLL PARCACC REGACC RETRCT
RETRCTT MNORDOT PPACCOT STAMPST ALLOWT
DISMNTT COLLFT MNORDRT PPACCRT COLREGT
LC_H PGBFCTR
TOTMIN	ACTLHRS 
                  LETTERS FLATS PARCELS BOXHOLD REGCERT CODCUST
                  DPS SECSEG MONORDR POSTDUE RETRCT TBOXES EVHRSO EVHRSR TEVHRS
                  TOTALT TPCS VARIABILITY LC_R OHLC_R DC_R VDC_R FDC_R
                  FCSPLV1 FCPSV1 FCSPCV1 FCPSCV1 PRIV1 EXPV1 PERV1 STD_ECRV1 STD_REGV1
                  PPV1 MLV1 BPMV1 USPSV1 FREEV1	INTLV1 V1
				  FCSPLV2 FCPSV2 FCSPCV2 FCPSCV2 PRIV2 EXPV2 PERV2 STD_ECRV2 STD_REGV2
                  PPV2 MLV2 BPMV2 USPSV2 FREEV2	INTLV2 V2
				  FCSPLV3 FCPSV3 FCSPCV3 FCPSCV3 PRIV3 EXPV3 PERV3 STD_ECRV3 STD_REGV3
                  PPV3 MLV3 BPMV3 USPSV3 FREEV3	INTLV3 V3
				  FCSPLV4 FCPSV4 FCSPCV4 FCPSCV4 PRIV4 EXPV4 PERV4 STD_ECRV4 STD_REGV4
                  PPV4 MLV4 BPMV4 USPSV4 FREEV4	INTLV4 V4
				  FCSPLV5 FCPSV5 FCSPCV5 FCPSCV5 PRIV5 EXPV5 PERV5 STD_ECRV5 STD_REGV5
                  PPV5 MLV5 BPMV5 USPSV5 FREEV5	INTLV5 V5
				  FCSPLV6 FCPSV6 FCSPCV6 FCPSCV6 PRIV6 EXPV6 PERV6 STD_ECRV6 STD_REGV6
                  PPV6 MLV6 BPMV6 USPSV6 FREEV6	INTLV6 V6
				  FCSPLV7 FCPSV7 FCSPCV7 FCPSCV7 PRIV7 EXPV7 PERV7 STD_ECRV7 STD_REGV7
                  PPV7 MLV7 BPMV7 USPSV7 FREEV7	INTLV7 V7
				  REGV CERTV INSV V8 CODV V9
				  FCSPLV FCPSV FCSPCV FCPSCV PRIV EXPV PERV STD_ECRV STD_REGV PPV MLV 
                  BPMV USPSV FREEV INTLV
				  FCSPL_NDC FCPS_NDC FCSPC_NDC FCPSC_NDC PRI_NDC EXP_NDC PER_NDC 
                  STD_ECR_NDC STD_REG_NDC PP_NDC ML_NDC BPM_NDC USPS_NDC FREE_NDC 
                  INTL_NDC REG_NDC CERT_NDC INS_NDC COD_NDC
				  FCSPL_R FCPS_R FCSPC_R FCPSC_R PRI_R EXP_R PER_R STD_ECR_R STD_REG_R 
                  PP_R ML_R BPM_R USPS_R FREE_R INTL_R REG_R CERT_R INS_R COD_R
				  NDC_R TC_R TR_R PF_R);
 SET R11;
 * added BOXESRT BOXESR BOXESCT BOXESC to be used in the rural analysis on density;
TITLE1 '2006 RURAL CARRIER NATIONAL MAIL COUNT';
TITLE2 'DAILY DATA';
/*
PROC MEANS MAXDEC=4 FW=14 DATA = OUT.RMC_06;
TITLE4 'AVERAGES OF ALL VARIABLES';
TITLE5 'ALL ROUTES IN THE UNIVERSE';
RUN;
PROC MEANS MAXDEC=4 FW=14 DATA = OUT.RMC_06;
VAR VARIABILITY;
WEIGHT TOTALT;
TITLE4 'AVERAGES OF ALL VARIABLES';
TITLE5 'ALL ROUTES IN THE UNIVERSE';
RUN; 
PROC PRINT DATA=OUT.RMC_06 (OBS=20);
TITLE4 '20 OBSERVATIONS FROM LAST DATA SET';
TITLE5;*/

RUN;







